/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.viewer;

import filenet.sim.apps.viewer.resources.VWSIMResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class VWSIMAnimatorSetTimeDelayDialog
extends VWModalDialog
implements ActionListener {
    private boolean m_bCanceled = false;
    private JTextArea m_infoTextArea = null;
    private JTextField m_timeDelayTextField = null;
    private JButton m_okButton = new JButton(VWSIMResource.s_ok);
    private JButton m_cancelButton = new JButton(VWSIMResource.s_cancel);
    private long m_delayTime = 1L;
    private long m_minDelayTime = 1L;
    private long m_maxDelayTime = 500L;

    public VWSIMAnimatorSetTimeDelayDialog(Frame parent, long delayTime, long min, long max) {
        super(parent);
        this.m_delayTime = delayTime;
        this.m_minDelayTime = min;
        this.m_maxDelayTime = max;
        this.setupLayout();
    }

    public VWSIMAnimatorSetTimeDelayDialog(Dialog parent, long delayTime, long min, long max) {
        super(parent);
        this.m_delayTime = delayTime;
        this.m_minDelayTime = min;
        this.m_maxDelayTime = max;
        this.setupLayout();
    }

    protected void setupLayout() {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension("400,155");
        if (dim == null) {
            dim = new Dimension(360, 140);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWSIMResource.s_setTimeDelay);
        String minString = Long.toString(this.m_minDelayTime);
        String maxString = Long.toString(this.m_maxDelayTime);
        this.m_infoTextArea = new JTextArea(VWSIMResource.s_setTimeDelayInfo.toString(minString, maxString));
        this.m_infoTextArea.setLineWrap(true);
        this.m_infoTextArea.setWrapStyleWord(true);
        this.m_infoTextArea.setOpaque(false);
        this.m_infoTextArea.setEditable(false);
        JTextArea noteArea = new JTextArea(VWSIMResource.s_setTimeDelayInfoNote);
        noteArea.setLineWrap(true);
        noteArea.setWrapStyleWord(true);
        noteArea.setOpaque(false);
        noteArea.setEditable(false);
        this.m_timeDelayTextField = new JTextField();
        this.m_timeDelayTextField.setText(Long.toString(this.m_delayTime));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.m_okButton);
        buttonPanel.add(this.m_cancelButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        mainPanel.setLayout(new GridBagLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(this.m_infoTextArea);
        panel.add(noteArea);
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        gbCons.gridwidth = 0;
        gbCons.insets = new Insets(4, 0, 0, 4);
        mainPanel.add((Component)panel, gbCons);
        ++gbCons.gridy;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(4, 0, 4, 4);
        mainPanel.add((Component)new JLabel(VWSIMResource.s_label.toString(VWSIMResource.s_delayTime)), gbCons);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.gridwidth = 2;
        mainPanel.add((Component)this.m_timeDelayTextField, gbCons);
        ++gbCons.gridx;
        gbCons.weightx = 0.0;
        gbCons.gridwidth = 1;
        mainPanel.add(new JLabel(VWSIMResource.s_miliseconds));
        gbCons.anchor = 10;
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.weightx = 0.0;
        gbCons.gridwidth = 0;
        mainPanel.add((Component)buttonPanel, gbCons);
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)mainPanel, "Center");
        this.m_okButton.addActionListener(this);
        this.m_cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_okButton);
        this.m_okButton.setSelected(true);
    }

    public void addNotify() {
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_infoTextArea.setFont(boldFont);
        }
        this.m_timeDelayTextField.requestFocus();
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    public long getDelayTime() {
        return this.m_delayTime;
    }

    private boolean parseDelayTime() {
        String timeString = this.m_timeDelayTextField.getText();
        long delay = 1L;
        try {
            delay = Long.parseLong(timeString);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, VWSIMResource.s_invalidValue, this.getTitle(), 0);
            return false;
        }
        if (delay < this.m_minDelayTime || delay > this.m_maxDelayTime) {
            JOptionPane.showMessageDialog(this, VWSIMResource.s_delayTimeOutOfRange, this.getTitle(), 0);
            return false;
        }
        this.m_delayTime = delay;
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_okButton) {
            this.m_bCanceled = false;
            if (this.parseDelayTime()) {
                this.setVisible(false);
            }
        } else if (source == this.m_cancelButton) {
            this.m_bCanceled = true;
            this.setVisible(false);
        } else if (source == this.m_timeDelayTextField) {
            JButton defButton = this.getRootPane().getDefaultButton();
            if (defButton != null) {
                defButton.doClick();
            } else if (this.m_okButton != null) {
                this.m_okButton.doClick();
            }
        }
    }
}

